using System;

namespace Reversi
{
	/// <summary>
	/// Opis klasy ReversiSilnik.
	/// </summary>
	public class ReversiSilnik
	{
		public const int planszaSzer=8;
		public const int planszaWys=8;
		public byte[,] plansza=new byte[planszaSzer,planszaWys];
		public byte nrGraczaWykonujacegoNastepnyRuch=1;

		public ReversiSilnik()
		{
			for (int i=0; i<planszaSzer; i++)
				for (int j=0; j<planszaWys; j++)
					plansza[i,j]=0;
			plansza[3,3]=1;
			plansza[4,4]=1;
			plansza[3,4]=2;
			plansza[4,3]=2;
		}

		public bool UstawPionek(int poziomo,int pionowo)
		{
			bool poprawnyRuch=false;

			//petla po 8 kierunkach
			for (int kierunekPoziomo=-1; kierunekPoziomo<=1; kierunekPoziomo++)
			for (int kierunekPionowo=-1; kierunekPionowo<=1; kierunekPionowo++)
			{
			if (kierunekPoziomo==0 && kierunekPionowo==0) kierunekPionowo++; //wymuszenie pominiecia przypadku gdy obie zmienne rowne 0
			//szukanie pionkow gracza w jednym z 8 kierunkow
			int szukajPoziomo=poziomo;
			int szukajPionowo=pionowo;
			bool znalezionyPionekPrzeciwnika=false;
			bool znalezionyPionekGraczaWykonujacegoRuch=false;
			bool znalezionePustePole=false;
			bool osiagnietaKrawedzPlanszy=false;
			do
				{
				szukajPoziomo+=kierunekPoziomo;
				szukajPionowo+=kierunekPionowo;
				osiagnietaKrawedzPlanszy=(szukajPoziomo<0 || szukajPionowo<0 || szukajPoziomo>=planszaSzer || szukajPionowo>=planszaWys);
				if (!osiagnietaKrawedzPlanszy)
					{
					znalezionyPionekGraczaWykonujacegoRuch=(plansza[szukajPoziomo,szukajPionowo]==nrGraczaWykonujacegoNastepnyRuch);
					if (!znalezionePustePole) znalezionePustePole=(plansza[szukajPoziomo,szukajPionowo]==0);
					if (!znalezionyPionekPrzeciwnika) znalezionyPionekPrzeciwnika=(plansza[szukajPoziomo,szukajPionowo]==((nrGraczaWykonujacegoNastepnyRuch==1)?2:1));
					}
				}
			while(!(osiagnietaKrawedzPlanszy || znalezionyPionekGraczaWykonujacegoRuch));

			//sprawdzenie warunku poprawnosci ruchu
			bool znalezione=(znalezionyPionekPrzeciwnika && znalezionyPionekGraczaWykonujacegoRuch && !znalezionePustePole);

			//odwrocenie pionkow w przypadku spelnionego warunku
			if (znalezione)
				{
				int maks_indeks=Math.Max(Math.Abs(szukajPoziomo-poziomo),Math.Abs(szukajPionowo-pionowo));
				for(int indeks=0;indeks<maks_indeks;indeks++)
					plansza[poziomo+indeks*kierunekPoziomo,pionowo+indeks*kierunekPionowo]=nrGraczaWykonujacegoNastepnyRuch;
				poprawnyRuch=true;
				}

			} //koniec petli po kierunkach

			//jezeli ruch zostal wykonany - zmiana gracza
			if (poprawnyRuch) nrGraczaWykonujacegoNastepnyRuch=(byte)((nrGraczaWykonujacegoNastepnyRuch==1)?2:1);

			return poprawnyRuch;
		}
	}
}
